#include "General.h"
#include "BuildingRevivalConsoleCommands.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "gmgame.h"
#include "Iterator.h"
#include "BuildingGameObj.h"
#include "BaseControllerClass.h"
#include "NetworkObjectClass.h"
#include "BuildingGameObjDef.h"
#include "RefineryGameObjDef.h"
#include "VehicleFactoryGameObj.h"
#include "CommandLineParser.h"
#include "GameObjManager.h"
#include "VehicleFactoryGameObjDef.h"
#include "BaseControllerClass.h"

#define GDI 1
#define NOD 0

void* HookupAT3x(void* a, void* b, void* c, void* patch_start, void* patch_end, int (*version_selector)())
{
	return HookupAT3(a,b,c,patch_start,patch_end,version_selector);
}

RENEGADE_FUNCTION
	void BuildingGameObj::Collect_Building_Components()
	AT2(0x006843E0,0x00683C80);

RENEGADE_FUNCTION
	void ScriptableGameObj::Start_Observers()
	AT2(0x006B64E0,0x006B64E0); // only for Win32 FDS

RENEGADE_FUNCTION
	void BaseControllerClass::Request_Harvester(int harvesterDefinitionId)
	AT2(0x006EEA20,0x006EEA20); // only for Win32 FDS

RENEGADE_FUNCTION
	BaseControllerClass *BaseControllerClass::Find_Base(int Team)
	AT2(0x006EF790,0x006EED50);

void Print_Scripts_On_Object(GameObject* obj)
{
	if (!obj)
	{
		return;
	}
	const SimpleDynVecClass<GameObjObserverClass *> *observers = &obj->Get_Observers();
	int x = observers->Count();
	for (int i = 0;i < x;i++)
	{
		Console_Output("%s\n", (*observers)[i]->Get_Name());
	}

}


void Update_Building_State(GameObject *Building, bool force_update)
{
	_asm
	{
		xor eax, eax
		mov al, force_update
		push eax
		mov ecx, Building
		mov	ebx, 0x00682F05
		call ebx
	}
}

void Initialize_Building(GameObject *Building)
{
	_asm
	{
		mov ecx, Building
		mov	ebx, 0x00683210
		call ebx
	}
}

void Request_New_Harvester(int Team)
{
	if (GameObject* Ref = Find_Refinery(Team))
	{
		int HarvDefID;
		_asm
		{
			mov     ecx, Ref
			mov		eax, [ecx+6BCh]			// get definition of Ref
			mov     ecx, [eax+0ACh]			// Get HarvesterDefID
			mov		[HarvDefID], ecx		// store it into HarvDefID
		}

		BaseControllerClass::Find_Base(Team)->Request_Harvester(HarvDefID);
	}
}


GameObject *Find_First_Dead_Building_Of_Type(int team, int type)
{
	SLNode<BuildingGameObj> *x = GameObjManager::BuildingGameObjList.Head();
	while (x)
	{
		BuildingGameObj *Building = x->Data();
		if (Building)
		{
			const BuildingGameObjDef *d = &Building->Get_Definition();
			if (d->Get_Type() == type)
			{
				if ((Get_Object_Type(Building) == team))
				{
					if (Is_Building_Dead(Building))
					{
						return Building;
					}
				}
			}
		}
		x = x->Next();
	}
	return nullptr;
}

GameObject *Find_First_Dead_Building_Preset_Name_Contains(int team, const char *PartialName)
{
	SLNode<BuildingGameObj> *x = GameObjManager::BuildingGameObjList.Head();
	while (x)
	{
		BuildingGameObj *Building = x->Data();
		if (Building)
		{
			if ((Get_Object_Type(Building) == team))
			{
				if (stristr(Commands->Get_Preset_Name(Building), PartialName))
				{
					if (Is_Building_Dead(Building))
					{
						return Building;
					}
				}
			}
		}
		x = x->Next();
	}
	return nullptr;
}

GameObject *Find_First_Dead_Building_Preset_Name(const char *PresetName)
{
	SLNode<BuildingGameObj> *x = GameObjManager::BuildingGameObjList.Head();
	while (x)
	{
		BuildingGameObj *Building = x->Data();
		if (Building)
		{
			if (_stricmp(Commands->Get_Preset_Name(Building), PresetName) == 0)
			{
				if (Is_Building_Dead(Building))
				{
					return Building;
				}
			}
		}
		x = x->Next();
	}
	return nullptr;
}

void Revive_Building(GameObject *Building)
{
	if (Building == nullptr ) return;
	if (!Building->As_BuildingGameObj()) return;
	if ( Is_Building_Dead(Building) == false ) return;

	int Team = ((DamageableGameObj*)Building)->Get_Player_Type();

//	Print_Scripts_On_Object(Building);

	SimpleDynVecClass<GameObjObserverClass *> RemoveObserversList;

	// Add every observer except any called "BuildingMonitorClass" to the RemoveObserverList
	const SimpleDynVecClass<GameObjObserverClass *> *observers = &Building->Get_Observers();
	int x = observers->Count();
	for (int i = 0;i < x;i++)
	{
		if (_stricmp((*observers)[i]->Get_Name(), "BuildingMonitorClass") != 0) 
		{
			RemoveObserversList.Add((observers->operator[](i)));

		}
	}

	// Then remove all observers in the RemoveObserverList from the building
	int x2 = RemoveObserversList.Count();
	for (int i = 0;i < x2;i++)
	{
		Building->Remove_Observer(RemoveObserversList[i]);
	}

	// This scripts.dll API function does the actual restoring
	Restore_Building(Building);

	// Make sure clients update the building state on their client
	Building->Set_Object_Dirty_Bit(NetworkObjectClass::BIT_RARE, true);
//	Update_Network_Object(Building);

	// Restore building health
	float max = Commands->Get_Max_Health(Building);
	Commands->Set_Health(Building, max);

	// This is needed to update the state of a building from 'dead' to 'alive on the client
	Update_Network_Object(Building);
	Commands->Apply_Damage(Building, 1.0f, "Explosive", 0);
	Update_Network_Object(Building);

	Commands->Apply_Damage(Building, 1.0f, "Explosive", 0); 
	Update_Network_Object(Building);

	// If we're a Power Plant turn on base power
	if (Building->As_BuildingGameObj()->As_PowerPlantGameObj() ) Power_Base(Team, true);

	// Set building power
	if (Is_Base_Powered(Team)) { Commands->Set_Building_Power(Building, true); }
	else { Commands->Set_Building_Power(Building, false); }

	// Check if Harv is dead and Ref is alive, if so request a new Harvester to be build
	GameObject *Ref = Find_Refinery(Team);
	GameObject *Harv = Find_Harvester(Team);
	bool RefDead = !( ( Ref != nullptr ) && ( Commands->Get_Health(Ref) != 0.0f ) );
	bool HarvDead = !( (Harv != nullptr ) && ( Commands->Get_Health(Harv) != 0.0f ) );

	if ( HarvDead && !RefDead )
	{
		Request_New_Harvester(Team);
	}

	// Needed for re-initialisation and also updating the state of the buidling
//	((BuildingGameObj*)Building)->Collect_Building_Components();
//	Update_Network_Object(Building);

//	Update_Building_State(Building, false);
//	Update_Network_Object(Building);

//	Initialize_Building(Building);
//	Update_Network_Object(Building);

//	Console_Output("Printing scripts on object now, should only contain BuildingMonitorClass:\n");
//	Print_Scripts_On_Object(Building);
//	Console_Output("Printing end.\n");

	// Restart observers,note this calls object create hooks
	Building->Start_Observers();

//	for( int i = 0; i < BuildingDef.ScriptNameList.Count(); i++)
//	{
//		Console_Output("%s\n", BuildingDef.ScriptNameList.operator[](i).Peek_Buffer());
//	}
//
//	for( int i = 0; i < BuildingDef.ScriptParameterList.Count(); i++)
//	{
//		Console_Output("%s\n",  BuildingDef.ScriptParameterList.operator[](i).Peek_Buffer());
//	}

	// Attach the scripts from the building's definition to the building
	const BuildingGameObjDef &BuildingDef = ((BuildingGameObj*)Building)->Get_Definition();

	for( int i = 0; i < BuildingDef.ScriptNameList.Count(); i++)
	{
		Commands->Attach_Script(Building, BuildingDef.ScriptNameList.operator[](i).Peek_Buffer(), 
			BuildingDef.ScriptParameterList.operator[](i).Peek_Buffer());
	}

//	Commands->Attach_Script(Building, "TDA_Conyard_Repair", ""); // debug crap test

//	Console_Output("Printing scripts after starting observers and attaching scripts from definition:\n");
//	Print_Scripts_On_Object(Building);
}

class CommandREVIVEBAR :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivebar"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEBAR - Revives the GDI Barracks."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *Barracks = Find_First_Dead_Building_Of_Type(GDI, BuildingConstants::TYPE_SOLDIER_FACTORY);
		Revive_Building(Barracks);
	}
};

class CommandREVIVEHON :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivehon"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEHON - Revives the Hand of Nod."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *HandOfNod = Find_First_Dead_Building_Of_Type(NOD, BuildingConstants::TYPE_SOLDIER_FACTORY);
		Revive_Building(HandOfNod);
	}
};

class CommandREVIVEGDIPP :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdipp"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIPP - Revives the GDI Power Plant."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *GDIPP = Find_First_Dead_Building_Of_Type(GDI, BuildingConstants::TYPE_POWER_PLANT);
		Revive_Building(GDIPP);
	}
};

class CommandREVIVENODPP :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodpp"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODPP - Revives the Nod Power Plant."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodPP = Find_First_Dead_Building_Of_Type(NOD, BuildingConstants::TYPE_POWER_PLANT);
		Revive_Building(NodPP);
	}
};

class CommandREVIVEGDICONYARD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdiconyard"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDICONYARD - Revives the GDI Construction Yard."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *GDICY = Find_First_Dead_Building_Of_Type(GDI, BuildingConstants::TYPE_CONYARD);
		Revive_Building(GDICY);
	}
};

class CommandREVIVENODCONYARD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodconyard"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODCONYARD - Revives the Nod Construction Yard."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodCY = Find_First_Dead_Building_Of_Type(NOD, BuildingConstants::TYPE_CONYARD);
		Revive_Building(NodCY);
	}
};

class CommandREVIVEGDIREF :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdiref"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIREF - Revives the GDI Refinery."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *GDIRef = Find_First_Dead_Building_Preset_Name_Contains(GDI, "Refinery");
		Revive_Building(GDIRef);
	}
};

class CommandREVIVENODREF :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodref"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODREF - Revives the Nod Refinery."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodRef = Find_First_Dead_Building_Preset_Name_Contains(NOD, "Refinery");
		Revive_Building(NodRef);
	}
};

class CommandREVIVEGDIREPBAY :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdirepbay"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIREPBAY - Revives the GDI Repair Bay."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *GDIRepBay = Find_First_Dead_Building_Preset_Name_Contains(GDI, "Rep");
		Revive_Building(GDIRepBay);
	}
};

class CommandREVIVENODREPBAY :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodrepbay"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODREPBAY - Revives the Nod Repair Bay."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodRepBay = Find_First_Dead_Building_Preset_Name_Contains(NOD, "Rep");
		Revive_Building(NodRepBay);
	}
};

class CommandREVIVEWF :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivewf"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEWF - Revives the GDI Weapons Factory."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *WF = Find_First_Dead_Building_Of_Type(GDI, BuildingConstants::TYPE_VEHICLE_FACTORY);
		Revive_Building(WF);
	}
};

class CommandREVIVEAIR :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveair"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEAIR - Revives the Nod Airstrip."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *Airstrip = Find_First_Dead_Building_Of_Type(NOD, BuildingConstants::TYPE_VEHICLE_FACTORY);
		Revive_Building(Airstrip);
	}
};

class CommandREVIVEGDICOMMCENTER :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdicommcenter"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDICOMMCENTER - Revives the GDI Communications Center."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *Com_Center =  Find_First_Dead_Building_Of_Type(GDI, BuildingConstants::TYPE_COM_CENTER);
		Revive_Building(Com_Center);
	}
};

class CommandREVIVENODCOMMCENTER :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodcommcenter"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODCOMMCENTER - Revives the Nod Communications Center."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *Com_Center =  Find_First_Dead_Building_Of_Type(NOD, BuildingConstants::TYPE_COM_CENTER);
		Revive_Building(Com_Center);
	}
};

class CommandREVIVEAGT :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveagt"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEAGT - Revives the GDI Advanced Guard Tower."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *AGT =  Find_First_Dead_Building_Preset_Name_Contains(GDI, "AGT");
		if (!AGT) AGT =  Find_First_Dead_Building_Preset_Name_Contains(GDI, "Advanced_Guard_Tower");
		if (!AGT) AGT =  Find_First_Dead_Building_Preset_Name_Contains(GDI, "AdvancedGuardTower");

		Revive_Building(AGT);
	}
};

class CommandREVIVEOB :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveob"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEOB - Revives the Nod Obelisk."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *Obelisk = Find_First_Dead_Building_Preset_Name_Contains(NOD, "Obelisk");
		Revive_Building(Obelisk);
	}
};

class CommandREVIVENODSILO :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodsilo"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODSILO - Revives the Nod Tiberium Silo."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodSilo = Find_First_Dead_Building_Preset_Name_Contains(NOD, "Silo");
		Revive_Building(NodSilo);
	}
};

class CommandREVIVEGDISILO :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdisilo"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDISILO - Revives the GDI Tiberium Silo."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *GDISilo = Find_First_Dead_Building_Preset_Name_Contains(GDI, "Silo");
		Revive_Building(GDISilo);
	}
};

class CommandREVIVENODHELIPAD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivenodhelipad"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVENODHELIPAD - Revives the Nod Helipad."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodHelipad = Find_First_Dead_Building_Preset_Name_Contains(NOD, "Heli");
		Revive_Building(NodHelipad);
	}
};

class CommandREVIVEGDIHELIPAD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivegdihelipad"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEGDIHELIPAD - Revives the GDI Helipad."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *GDIHelipad = Find_First_Dead_Building_Preset_Name_Contains(GDI, "Heli");
		Revive_Building(GDIHelipad);
	}
};

class CommandREVIVESHRINE :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "reviveshrine"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVESHRINE - Revives the Shrine of Nod."; 
	}
	void Activate(const char* argumentsString)
	{
		GameObject *NodHelipad = Find_First_Dead_Building_Preset_Name_Contains(NOD, "Shrine");
		Revive_Building(NodHelipad);
	}
};


class CommandREVIVEBUILDINGBYID :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivebuildingbyid"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEBUILDINGBYID <OBJECTID> - Revives a building by its object ID."; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);

		int ObjectID = arguments.getInt();
		GameObject *Building = Commands->Find_Object(ObjectID);
		Revive_Building(Building);
	}
};

class CommandREVIVEBUILDINGBYPRESET :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "revivebuildingbypreset"; 
	}
	const char* Get_Help() 
	{ 
		return "REVIVEBUILDINGBYPRESET <PRESET NAME> - Revives a building by it's preset name."; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);

		StringClass Args = arguments.getString();
		Args.Trim();

		GameObject *Building = Find_First_Dead_Building_Preset_Name(Args);
		Revive_Building(Building);
	}
};



class BUILDINGREVIVALCONSOLECOMMANDS : public Plugin
{
public:
	BUILDINGREVIVALCONSOLECOMMANDS()
	{
		ConsoleFunctionList.Add(new CommandREVIVEBAR);
		ConsoleFunctionList.Add(new CommandREVIVEHON);
		ConsoleFunctionList.Add(new CommandREVIVEGDIPP);
		ConsoleFunctionList.Add(new CommandREVIVENODPP);
		ConsoleFunctionList.Add(new CommandREVIVEGDICONYARD);
		ConsoleFunctionList.Add(new CommandREVIVENODCONYARD);
		ConsoleFunctionList.Add(new CommandREVIVEGDIREF);
		ConsoleFunctionList.Add(new CommandREVIVENODREF);
		ConsoleFunctionList.Add(new CommandREVIVEGDIREPBAY);
		ConsoleFunctionList.Add(new CommandREVIVENODREPBAY);
		ConsoleFunctionList.Add(new CommandREVIVEWF);
		ConsoleFunctionList.Add(new CommandREVIVEAIR);
		ConsoleFunctionList.Add(new CommandREVIVEGDICOMMCENTER);
		ConsoleFunctionList.Add(new CommandREVIVENODCOMMCENTER);
		ConsoleFunctionList.Add(new CommandREVIVEAGT);
		ConsoleFunctionList.Add(new CommandREVIVEOB);
		ConsoleFunctionList.Add(new CommandREVIVENODSILO);
		ConsoleFunctionList.Add(new CommandREVIVEGDISILO);
		ConsoleFunctionList.Add(new CommandREVIVENODHELIPAD);
		ConsoleFunctionList.Add(new CommandREVIVEGDIHELIPAD);
		ConsoleFunctionList.Add(new CommandREVIVESHRINE);

		ConsoleFunctionList.Add(new CommandREVIVEBUILDINGBYID);
		ConsoleFunctionList.Add(new CommandREVIVEBUILDINGBYPRESET);

		Sort_Function_List();
		Verbose_Help_File();
	}
	~BUILDINGREVIVALCONSOLECOMMANDS()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "revivebuildingbyid") == 0 || strcmp(name, "revivebuildingbypreset") == 0 || strcmp(name, "reviveshrine") == 0 || strcmp(name, "revivegdihelipad") == 0 || strcmp(name, "revivenodhelipad") == 0 || strcmp(name, "revivegdisilo") == 0 || strcmp(name, "revivenodsilo") == 0 || strcmp(name, "revivebar") == 0 || strcmp(name, "revivehon") == 0 || strcmp(name, "revivegdipp") == 0 || strcmp(name, "revivenodpp") == 0 || strcmp(name, "revivegdiconyard") == 0 || strcmp(name, "revivenodconyard") == 0 || strcmp(name, "revivegdiref") == 0 || strcmp(name, "revivenodref") == 0 || strcmp(name, "revivegdirepbay") == 0 || strcmp(name, "revivenodrepbay") == 0 || strcmp(name, "revivewf") == 0 || strcmp(name, "reviveair") == 0 || strcmp(name, "revivegdicommcenter") == 0 || strcmp(name, "revivenodcommcenter") == 0 || strcmp(name, "reviveagt") == 0 ||strcmp(name, "reviveob") == 0) 
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

BUILDINGREVIVALCONSOLECOMMANDS buildingrevivalconsolecommands;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &buildingrevivalconsolecommands;
}
